// eslint-disable-next-line no-unused-vars
async function carregaParametrosLogin() {
  const empId = getCookie("emp_id");
  if (!empId) {
    window.location.href = `${BASE_URI}/login`;
    return '';
  }
  const url = `/sisplan/funcoes/v1/pesquisa?`;
  const pesquisa = {
    tabela: "loja_param",
    camposSelect: ["tipo", "posicao", "valor"],
    where: [`emp_id = ${empId}`],
    orderBy: ['tipo', 'posicao']
  };
  const response = await requisicao(
    "GET",
    url,
    `JSON=${JSON.stringify(pesquisa)}`,
    null
  );

  if (!response) {
    throw new Error("Não foi possível buscar os parametros da empresa logada.");
  }

  const jsonStr = await response.json();

  const acessosEmpresa = jsonStr.RESULT[0];
  sessionStorage.setItem('web@parametros', JSON.stringify(acessosEmpresa));

  if (response.status != 200) {
    msgAlerta(jsonStr.RESULT[0].mensagem);
    throw new Error("Não foi possível buscar os parametros da empresa logada.");
  }
}

// eslint-disable-next-line no-unused-vars
async function carregaEmpValorLogin() {
  const empId = getCookie("emp_id");
  if (!empId) {
    window.location.href = `${BASE_URI}/login`;
    return '';
  }
  const url = `/sisplan/funcoes/v1/pesquisa?`;
  const pesquisa = {
    tabela: "EMP_VALOR",
    camposSelect: ["TABELA", "VALOR"],
    where: [`EMP_ID = ${empId}`]
  };


  //   const response = await requisicao(
  //     "GET",
  //     url,
  //     `JSON={ "tabela":"EMP_VALOR", "camposSelect":["EMP_ID", "VALOR"], "where": ["TABELA = '${tabela}' AND EMP_ID=${getCookie(
  //         "emp_id"
  //     )}"]}`
  // );

  const response = await requisicao(
    "GET",
    url,
    `JSON=${JSON.stringify(pesquisa)}`,
    null
  );

  if (!response) {
    throw new Error("Não foi possível buscar os parametros da empresa logada.");
  }

  const jsonStr = await response.json();

  const dados = jsonStr.RESULT[0];
  sessionStorage.setItem('web@empValor', JSON.stringify(dados));

  if (response.status != 200) {
    msgAlerta(jsonStr.RESULT[0].mensagem);
    throw new Error("Não foi possível buscar os parametros da empresa logada.");
  }
}

async function acessoRetaguardaSupervisor() {
  const url = `/sisplan/funcoes/v1/pesquisa?`;
  const pesquisa = {
    tabela: "ACESSO_LOJAWEB",
    camposSelect: ["ACESSO_LOJAWEB.CODIGO"],
    leftjoin: [{ tabela: 'ACESSO_USUARIOS', condicao: 'ACESSO_USUARIOS.CODIGO = ACESSO_LOJAWEB.CODIGO' }],
    where: [`ACESSO_LOJAWEB.NOME_TELA = 'RETAGUARDASUPERVISOR'
              AND ACESSO_LOJAWEB.CONSULTA = 'S'
              AND ACESSO_LOJAWEB.ALTERA = 'S'
              AND ((ACESSO_USUARIOS.TIPO = '1') OR (ACESSO_USUARIOS.TIPO = '2'))`]
  };
  const response = await requisicao(
    "GET",
    url,
    `JSON=${JSON.stringify(pesquisa)}`,
    null
  );

  if (!response) {
    throw new Error("Ocorreu um erro ao realizar pesquisa.");
  }

  const jsonStr = await response.json();

  const acessosEmpresa = jsonStr.RESULT[0];
  if (acessosEmpresa.length <= 0) {
    sessionStorage.setItem('acessoretaguardasupervisor', 'N');
  } else {
    sessionStorage.setItem('acessoretaguardasupervisor', 'S');
  }

  if (response.status != 200) {
    msgAlerta(jsonStr.RESULT[0].mensagem);
    throw new Error("Ocorreu um erro ao realizar pesquisa");
  }
}

async function retornaIdiomaUsuario() {
  $.LoadingOverlay('show')
  try {
    let usuario = pegaValor('#txtEmail')
    usuario = usuario.indexOf('SISPLAN') == -1 ? usuario : 'SISPLAN';
    const response = await requisicao('GET', '/sisplan/usuario/v1/buscaidiomausuario?', `EMPRESA=_001&NOME=${usuario}`, null);
    if (!response || response.status != 200) {
      $.LoadingOverlay('hide')
      setCookie('idiomaUsuario', 'P');
      return;
    }

    const jsonStr = await response.text();

    setCookie('idiomaUsuario', ['I', 'E', 'M', 'P'].includes(jsonStr) ? jsonStr : 'P');

    const idioma = getCookie('idiomaUsuario');
    if (idioma == 'P' || idioma == '') {
      return;
    }
    await salvarTraducoes()
    await mudaIdiomaLogin()
  } catch (error) {
    console.error(error)
  } finally {
    $.LoadingOverlay('hide')
  }
}

async function mudaIdiomaLogin() {
  const idioma = getCookie('idiomaUsuario');
  if (idioma == 'P' || idioma == '') {
    return;
  }

  await traduzirLogin('.loginForm')
}

async function salvarTraducoes() {
  try {
    indexedDB.deleteDatabase('Traducoes')
    const db = await criaDB("Traducoes", 1, criarObjectStore);
    const translations = await carregarTraducoesDoArquivo(`${BASE_URI}/utils/translations.json`);
    const idioma = getCookie('idiomaUsuario')

    const traducoesFiltradas = translations.map(item => {
      const traducaoFiltrada = {};
      for (const chave in item) {
        traducaoFiltrada[chave] = item[chave][idioma];
      }
      return traducaoFiltrada;
    });

    await limparObjectStore(db, "translations");

    await salvarTraducoesNoBanco(db, traducoesFiltradas);
  } catch (error) {
    console.error("Erro ao salvar traduções:", error);
    return []
  }
}

function limparObjectStore(db, storeName) {
  return new Promise((resolve, reject) => {
    const transaction = db.transaction(storeName, "readwrite");
    const store = transaction.objectStore(storeName);
    const request = store.clear();

    transaction.oncomplete = () => resolve();
    transaction.onerror = () => reject("Erro ao limpar o objectStore");
  });
}

function criaDB(nomeBanco, versao, onUpgradeNeeded) {
  return new Promise((resolve, reject) => {
    const request = indexedDB.open(nomeBanco, versao);

    request.onerror = () => reject(new Error("Erro ao abrir o banco de dados"));
    request.onsuccess = () => resolve(request.result);
    request.onupgradeneeded = (e) => onUpgradeNeeded(e);
  });
}

function criarObjectStore(event) {
  const db = event.target.result;

  if (!db.objectStoreNames.contains("translations")) {
    db.createObjectStore("translations", { keyPath: "n" });
  }
}

async function carregarTraducoesDoArquivo(url) {
  const response = await fetch(url);
  if (!response.ok) {
    throw new Error("Erro ao carregar o arquivo de traduções");
  }
  const data = await response.json();
  return data.translations;
}

async function salvarTraducoesNoBanco(db, translations) {
  function normalizeText(text) {
    return text
      .normalize("NFD")
      .replace(/\p{Diacritic}/gu, "")
      .replace(/[^a-zA-Z0-9\s]/g, "")
      .toUpperCase()
      .trim();
  }

  await limparObjectStore(db, "translations");

  return new Promise((resolve, reject) => {
    const transaction = db.transaction("translations", "readwrite");
    const store = transaction.objectStore("translations");

    const registrosParaInserir = translations.flatMap((item) => {
      return Object.entries(item).map(([nome, valor]) => ({
        n: normalizeText(nome),
        t: valor,
      }));
    });

    const promises = registrosParaInserir.map((registro) => {
      return new Promise((resolve, reject) => {
        const request = store.put(registro);
        request.onsuccess = () => resolve();
        request.onerror = () => reject(request.error);
      });
    });

    Promise.all(promises)
      .then(() => {
        transaction.oncomplete = () => resolve();
      })
      .catch((error) => {
        transaction.abort();
        reject(new Error("Erro ao salvar traduções no banco de dados: " + error.message));
      });
  });
}

async function limparObjectStore(db, storeName) {
  return new Promise((resolve, reject) => {
    const transaction = db.transaction(storeName, "readwrite");
    const store = transaction.objectStore(storeName);
    const request = store.clear();

    request.onsuccess = () => resolve();
    request.onerror = () => reject(new Error("Erro ao limpar o objectStore"));
  });
}
