$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCaixa",
        popover: {
          title: "Caixa",
          description:
            "Aqui adicionamos o caixa.",
          position: "top",
        },
      },
      {
        element: "#txtUsuario",
        popover: {
          title: "Usuário",
          description:
            "E aqui adicionamos o usuário que será o vendedor.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o caixa.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let objVendCaixa = parametros[parametros.length - 1];

  $("#txtCaixa").autocompleta(1, `JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO chave", "DESCRICAO"], "where": null}`);
  $("#btn-Caixa").pesquisa("#txtCaixa", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Caixa", "CAIXA_LOJA");
  $("#btn-limpa-Caixa").on("click", function () {
    $("#txtCaixa").val("");
  });

  $("#txtUsuario").autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO chave", "NOME descricao"], "where": null}`);
  $("#btn-Usuario").pesquisa("#txtUsuario", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO", "NOME"]}`, "Pesquisa Usuário", "CAIXA_LOJA");
  $("#btn-limpa-Usuario").on("click", function () {
    $("#txtUsuario").val("");
  });

  $("#txtDeposito").autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO chave", "descricao"], "where": null}`);
  $("#btn-Deposito").pesquisa("#txtDeposito", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Depósito", "DEPOSITO");
  $("#btn-limpa-Deposito").on("click", function () {
    $("#txtDeposito").val("");
  });

  $("#txtContaC").autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA chave", "EMPRESA descricao"], "where": null}`);
  $("#btn-ContaC").pesquisa("#txtContaC", "CONTA", "EMPRESA", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "EMPRESA"]}`, "Pesquisa Conta Corrente", "DEPOSITO");
  $("#btn-limpa-ContaC").on("click", function () {
    $("#txtContaC").val("");
  });

  $("#txtTabelaPreco").autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $("#btnTabelaPreco").pesquisa("#txtTabelaPreco", "REGIAO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"]}`, "Pesquisa Tabela Preco", "REGIAO");
  $("#btnLimpaTabelaPreco").on("click", function () {
    $("#txtTabelaPreco").val("");
  });

  $("#btnVoltar").on("click", async function () {
    window.location.href = `${BASE_URI}/vendedorcaixa`;
  });

  $(document).ready(async function () {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtCaixa: {
          required: true,
        },
        txtUsuario: {
          required: true,
        },
      },
      messages: {
        txtCaixa: {
          required: "Informe um caixa válido.",
        },
        txtUsuario: {
          required: "Informe um usuário válido.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });

    if (objVendCaixa != "" && objVendCaixa != "create") {
      objVendCaixa = JSON.parse(atob(objVendCaixa));
      carregaDados(objVendCaixa.NRCAIXA, objVendCaixa.USUARIO);
    }

    async function carregaDados(sCaixa, sUsuario) {
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ 
                "tabela":"VENDA_CAIXA", 
                "camposSelect":["VENDA_CAIXA.CONTA", "VENDA_CAIXA.DEPOSITO", "VENDA_CAIXA.DESCRICAO DESC_VENDACX", "VENDA_CAIXA.NRCAIXA", "VENDA_CAIXA.NUM_ECF", 
                "VENDA_CAIXA.USUARIO", "CADCONTA.EMPRESA", "DEPOSITO.DESCRICAO DESC_DEPOSITO", "CAIXA_LOJA.DESCRICAO DESC_CX", "ACESSO_USUARIOS.CODIGO", 
                "VENDA_CAIXA.REGIAO", "REGIAO.DESCRICAO AS DESC_REGIAO"], 
                "leftjoin": [{"tabela": "CADCONTA", "condicao": "VENDA_CAIXA.CONTA = CADCONTA.CONTA"},
                  {"tabela": "DEPOSITO", "condicao": "VENDA_CAIXA.DEPOSITO = DEPOSITO.CODIGO"},
                  {"tabela": "CAIXA_LOJA", "condicao": "VENDA_CAIXA.NRCAIXA = CAIXA_LOJA.CODIGO"},
                  {"tabela": "ACESSO_USUARIOS", "condicao": "VENDA_CAIXA.USUARIO = ACESSO_USUARIOS.NOME"},
                  {"tabela": "REGIAO", "condicao": "VENDA_CAIXA.REGIAO = REGIAO.REGIAO"}],
                "where": ["VENDA_CAIXA.NRCAIXA = '${sCaixa}' AND VENDA_CAIXA.USUARIO = '${sUsuario}'"]}`,
            null
          );

          if (!response) {
            return;
          }

          let jsonStr = await response.json();

          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          jsonStr = jsonStr.RESULT[0][0];

          insereValor('#txtCaixa', jsonStr.NRCAIXA, jsonStr.DESC_CX);
          insereValor('#txtUsuario', jsonStr.CODIGO, jsonStr.USUARIO);
          insereValor(jsonStr.DEPOSITO != '' ? '#txtDeposito' : '', jsonStr.DEPOSITO, jsonStr.DESC_DEPOSITO);
          insereValor(jsonStr.CONTA != '' ? '#txtContaC' : '', jsonStr.CONTA, jsonStr.EMPRESA);
          insereValor('#txtTabelaPreco', jsonStr.REGIAO, jsonStr.DESC_REGIAO);

          $("#txtDescricao").val(jsonStr.DESC_VENDACX);
          $("#txtNumeroECF").val(jsonStr.NUM_ECF);

        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados do caixa: ${error}`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }

    $(".radio-group .radio").click(function () {
      $(this).parent().find(".radio").removeClass("selected");
      $(this).addClass("selected");
    });

    $(".submit").click(function () {
      return false;
    });
  });

  $("#btnGravar").click(async function () {
    try {
      let validator = $("#msform").validate();
      validator.form();
      let erros = 0;
      erros = validator.numberOfInvalids();

      if (erros == 0) {
        $.LoadingOverlay("show");

        let oVendCaixa = {
          CONTA: pegaChave('#txtContaC'),
          DEPOSITO: pegaChave('#txtDeposito'),
          DESCRICAO: $("#txtDescricao").val().toUpperCase(),
          NRCAIXA: pegaChave('#txtCaixa'),
          NUM_ECF: $("#txtNumeroECF").val(),
          USUARIO: pegaDescricao('#txtUsuario'),
          EMP_ID: getCookie('emp_id'),
          REGIAO: pegaChave('#txtTabelaPreco'),
        };

        let response = await requisicao(
          "POST",
          "/sisplan/cadastros/v1/vendedorcaixa?",
          `JSON=${encodeURIComponent(JSON.stringify(oVendCaixa))}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success(`Cadastro efetuado com sucesso!`,
            "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/vendedorcaixa`;
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      }
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível gravar os dados do caixa: ${error}`);
    }
  });
});
