$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    })
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir uma nova operação.",
          position: "right",
        },
      },
      {
        element: "#tabelaItens",
        popover: {
          title: "Tabela de Operações",
          description: "Aqui está a lista de operações cadastradas.",
          position: "top",
        },
      },
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  preencherFiltrosSalvos()
  const permissaoUsuarioLogado = await permissaoAcessos('FORMACAO_KIT');

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show')
  })

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI === 'S') {
      window.location.href = 'formacao_kit/create'
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  })

  componenteFiltro('numeroKit', true, true, 'Numero')
  componenteFiltro('produto', true, true)

  $('#btnConsultar').on('click', function () {
    consultar().then(() => $('#modal-filtros').modal('hide'))
  })

  async function retornarFiltros() {
    const numeros = await formataListas($('#txtNumero').val().toString())
    const produtos = await formataListas($('#txtProduto').val().toString())

    return {
      numeros,
      produtos,
    }
  }

  async function consultar() {
    const filtros = await retornarFiltros()
    atualizarFiltrosAbasAcessoSessionStorage('formacao_kit', filtros)
    carregarTabelaItens(filtros)
  }

  function retornarBotaoOpcoes(data) {
    const retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>     ' +
      '</div>'
    return retorno
  }

  function carregarTabelaItens(filtros) {
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy();
      $('#tabelaItens').empty();
    }

    const columns = [
      {
        data: 'numero',
        title: 'Número',
        render: function (data) {
          return retornarBotaoOpcoes(data);
        },
      },
      {
        data: 'descKit',
        title: 'Desc. Kit',
      },
      {
        data: 'produto',
        title: 'Produto',
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
    ]

    $('#tabelaItens').DataTable({
      sort: false,
      paging: true,
      destroy: true,
      lengthChange: true,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      colReorder: true,
      serverSide: true,
      ajax: {
        url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/acesso_formacao_kit/v1/dados`,
        type: "GET",
        headers: {
          'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
        },
        data: {
          EMPRESA: getCookie('empresa'),
          FILTROS: JSON.stringify(filtros) ?? "{}",
        },
        dataSrc: function (json) {
          if (!json || !json.data) {
            return []
          }
          return json.data
        },
        cache: true,
        beforeSend: function () {
          $.LoadingOverlay('show')
        },
        complete: function () {
          $.LoadingOverlay('hide')
        },
      },
      autoWidth: true,
      columns,
      scrollX: true,
      scrollY: '55vh',
    })
  }

  function preencherFiltrosSalvos() {
    const filtrosSessionStorage = sessionStorage.getItem('filtrosConsultasAbasAcesso')
    if (filtrosSessionStorage) {
      const { formacao_kit: filtros } = JSON.parse(filtrosSessionStorage)
      if (filtros) {
        carregarFiltrosSalvos(filtros).then(({ numeros, produtos, }) => {
          if (numeros) numeros.forEach((item) => adicionaValorPadraoVarios('numero', item?.codigo, item?.descricao))
          if (produtos) produtos.forEach((item) => adicionaValorPadraoVarios('produto', item?.codigo, item?.descricao))
          consultar()
        }).catch(
          () => msgErro('Ocorreu um erro ao preencher os filtros salvos.')
        ).finally(() => { })
      }
    }
  }

  async function carregarFiltrosSalvos(filtros) {
    const response = await requisicao("GET", `/Sisplan/acesso_formacao_kit/v1/filtros?`, `FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`, '', 3600000)
    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  $('#btnLimparFiltros').on('click', function () {
    $('#txtNumero').empty().trigger('change')
    $('#txtProduto').empty().trigger('change')
  })

  $('#tabelaItens').on('click', '#btnEditar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
      if (data) {
        let registroLiberado = await verificarRegistro('FORMACAO_KIT', data?.produto)
        if (registroLiberado) {
          window.location.href = `formacao_kit/PRODUTO=${encodeURIComponent(data.produto)}&NUMERO=${encodeURIComponent(data.numero)}`
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  })

  $('#tabelaItens').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaItens').DataTable().row($(this)).data()
      if (data) {
        let registroLiberado = await verificarRegistro('FORMACAO_KIT', data?.produto)
        if (registroLiberado) {
          window.location.href = `formacao_kit/PRODUTO=${encodeURIComponent(data.produto)}&NUMERO=${encodeURIComponent(data.numero)}`
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!")
    }
  })

  $('#tabelaItens').on('click', '#btnExcluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const row = $('#tabelaItens').DataTable().row($(this).parents('tr'))
      let data = row.data()
      if (data) {
        let registroLiberado = await verificarRegistro('FORMACAO_KIT', data?.produto)
        if (registroLiberado) {
          msgAlerta(
            'Deseja excluir a operação selecionada?',
            () => { },
            () => { },
            () => excluir(data?.numero, data?.produto, row),
          )
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  })

  async function excluir(numero, produto, row) {
    if (!numero || !produto || !row) return
    $.LoadingOverlay('show')
    requisicao("DELETE", `/sisplan/formacao_kit/v1/kit?`, `&DADOS=${encodeURIComponent(JSON.stringify({ numero, produto }))}`, '', 3600000)
      .then(async (response) => {
        if (response.status !== 204) {
          const json = await response.json()
          console.error(json?.mensagem?.mensagem)
          throw json?.mensagem?.mensagem
        }

        toastr.success("Kit excluído com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            row.remove().draw(false)
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }).catch((error) => msgErro(error || 'Ocorreu um erro ao realizar a exclusão.')
      ).finally(() => $.LoadingOverlay('hide'))
  }
})