componenteFiltro("banco", false, false, "BancoVindi");
componenteFiltro("conta", false, false, "ContaVindi");
componenteFiltro("classe", false, false, "ClasseBaixaVindi");
componenteFiltro("classe", false, false, "ClasseTaxaVindi");
componenteFiltro("historico", false, false, "HistoricoVindi");
componenteFiltro("moeda", false, false, "MoedaVindi");

function criaDataTableVindi() {
  $("#tabelaVindi").DataTable({
    paging: true,
    filter: false,
    info: false,
    length: false,
    order: false,
    destroy: true,
    data: {},
    columns: dataSetColsVindi,
    columnDefs: [
      {
        targets: [0], render: function (_data, _type, _row, meta) {
          return `<div class="icheck-primary d-inline">
										<input type="checkbox" ${(_row.SEL === 'S') ? 'checked' : 'disabled'} id="check_col_${meta.row}_row_${meta.col}">
										<label for="check_col_${meta.row}_row_${meta.col}"></label>
									</div>`;
        },
      },
      {
        type: 'date-br',
        targets: [10, 11, 12],
        render(data) {
          if (data) {
            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
          } else {
            return '';
          }

        },
      },
      {
        targets: [5, 6, 7, 15],
        render(data) {
          return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
        },
        "className": 'pr-4 text-right'
      }
    ],
  });
};

$('#btnVerBaixasVindi').on('click', async function () {
  insereDadosNaTabela();
});

$('#btnConfirmarVindi').on('click', async function () {
  gravaDadosNaTabela(); 
});

function retornaFiltros() {
  const banco = pegaChave('#txtBancoVindi');
  const conta = pegaChave('#txtContaVindi');
  const classeBaixa = pegaChave('#txtClasseBaixaVindi');
  const classeTaxa = pegaChave('#txtClasseTaxaVindi');
  const historico = pegaChave('#txtHistoricoVindi');
  const moeda = pegaChave('#txtMoedaVindi');

  return `BANCO=${banco}&CONTA=${conta}&CLASSE_BAIXA=${classeBaixa}&CLASSE_TAXA=${classeTaxa}&HISTORICO=${historico}&MOEDA=${moeda}`;
};

async function insereDadosNaTabela() {
  $.LoadingOverlay('show');
  try {
    $('#tabelaVindi').DataTable().clear().draw(false);
    
    const url = '/sisplan/escretorno/v1/buscabaixasvindi?';

    const params = retornaFiltros();

    const listaRegistrosVindi = [];

    for (let i = 0; i < window.databody.length; i++) {
      const obj = {
        "sel": window.databody[i].sel,
        "nsu": window.databody[i].nsu,
        "parcela": window.databody[i].parcela,
        "dt_pagamento": window.databody[i].dt_pagamento,
      };
      listaRegistrosVindi.push(obj);
    };

    let response = await requisicao('POST', url, `${params}&LISTA_REGISTROS=${JSON.stringify({ DATA: listaRegistrosVindi })}`, ``);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (!jsonStr || jsonStr.length === 0) {
      msgAlerta('Não foi possível encontrar os dados das baixas do extrato de cartão Vindi. Por favor, tente novamente.');
      return
    };

    $('#tabelaVindi').DataTable().rows.add(jsonStr).draw(false);
  } catch (error) {
    console.error(error);
    msgErro(`Ocorreu um erro ao ver as baixas do arquivo vindi! Por favor, verifique. Erro: ${error}`)
  } finally {
    $.LoadingOverlay('hide');
  }
};

criaDataTableVindi();

async function gravaDadosNaTabela() {
  $.LoadingOverlay('show');
  try {
    const url = '/sisplan/escretorno/v1/gravabaixasvindi?';

    const params = retornaFiltros();

    const listaBaixasVindi = [];

    const dataTableVindi = $('#tabelaVindi').DataTable().rows().data();

    for (let i = 0; i < dataTableVindi.length; i++) {
      if (dataTableVindi[i].SEL === 'S') {
        const obj = {
          "NUMERO": dataTableVindi[i].NUMERO,
          "CODCLI": dataTableVindi[i].COD_CLI,
          "DT_PAGAMENTO": dataTableVindi[i].DT_PAGAMENTO,
          "VALOR_LIQUIDO": dataTableVindi[i].VALOR_LIQUIDO,
          "VALOR_PAGO": dataTableVindi[i].VALOR_LIQUIDO,
          "DT_EMISSAO": dataTableVindi[i].DT_EMISSAO,
          "FATURA": dataTableVindi[i].FATURA,
        };
        listaBaixasVindi.push(obj);
      }
    };
    if (listaBaixasVindi.length === 0) {
      msgAlerta('Nenhum registro selecionado para baixa. Por favor, selecione ao menos um registro.');
      return;
    };

    let response = await requisicao('POST', url, `${params}&LISTA_BAIXAS=${JSON.stringify({ DATA: listaBaixasVindi })}`, ``);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (response.status !== 200) {
      msgAlerta('Não foi possível gravar os dados das baixas do extrato de cartão Vindi. Por favor, tente novamente.');
      return
    };

    msgSucesso('Baixas do arquivo Vindi gravadas com sucesso!');
    
    window.location.reload();
  } catch (error) {
    console.error(error);
    msgErro(`Ocorreu um erro ao gravar as baixas do arquivo vindi! Por favor, verifique. Erro: ${error}`)
  } finally {
    $.LoadingOverlay('hide'); 
  }
}
