$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui está o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui está o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  componenteFiltro('cotacao', true, true)
  componenteFiltro('solicitacao', true, true)
  componenteFiltro('fornecedor', true, true)
  componenteFiltro('itemCotacao', true, true, 'Codigo')
  componenteFiltro('cor', true, true)
  componenteFiltro('tamanho2', true, true, 'Tamanho')
  componenteFiltro('funcionario', true, true, 'Solicitante')
  componenteFiltro('centroCusto', true, true)
  componenteFiltro('tipo', true, true)

  $('#btnConsultar').on('click', function () {
    consultar()
    $('#modalFiltros').modal('hide')
  })

  function consultar() {
    ItensCotacaoNegociados.retornarFiltros()
      .then((filtros) => {
        ItensCotacaoNegociados.criarTabelaItens({ filtros })
      })
  }

  consultar()
  $('#tabelaItens').on('click', '#btnMapaCotacao', async function () {
    const datatable = $('#tabelaItens').DataTable()
    const { numero } = datatable?.row($(this)?.parents('tr'))?.data()
    $.LoadingOverlay('show')
    ModalMapaCotacaoNegociados.buscarDados(numero).then((dados) => {
      if (!dados) {
        return
      }

      ModalMapaCotacaoNegociados.carregar({ ...dados })
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao carregar os dados.')
    }).finally(() => $.LoadingOverlay('hide'))
  })

  function limparFiltros() {
    $('#txtCotacao').empty().trigger('change')
    $('#txtSolicitacao').empty().trigger('change')
    $('#txtFornecedor').empty().trigger('change')
    $('#txtCodigo').empty().trigger('change')
    $('#txtCor').empty().trigger('change')
    $('#txtTamanho').empty().trigger('change')
    $('#txtSolicitante').empty().trigger('change')
    $('#txtCentroCusto').empty().trigger('change')
    $('#txtTipo').empty().trigger('change')
    $('#txtCodigoFornecedor').val('')
    $('#txtCorFornecedor').val('')
    $('#txtValidadeDe').val('1200-01-01')
    $('#txtValidadeAte').val('2500-12-31')
    $('#txtRespostaDe').val('1200-01-01')
    $('#txtRespostaAte').val('2500-12-31')
  }

  $('#btnLimparFiltros').on('click', function () {
    limparFiltros()
  })

  $('#btnFiltros').on('click', function () {
    $('#modalFiltros').modal('show')
  })

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/central_compras`
  })
})

window.ItensCotacaoNegociados = window.ItensCotacaoNegociados || {}

ItensCotacaoNegociados.idSelecionado = 0

ItensCotacaoNegociados.criarTabelaItens = ({ filtros }) => {
  if ($.fn.DataTable.isDataTable('#tabelaItens')) {
    $('#tabelaItens').DataTable().destroy()
    $('#tabelaItens').empty()
  }

  const columns = [
    {
      data: 'numero',
      title: 'Número',
      render: (data) => (
        '<div style="text-align:start;"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
        '      ' + data + ' ' +
        '    </button> ' +
        '    <div class="dropdown-menu"> ' +
        '    <button class="dropdown-item" type="button" title="Mapa Cotação" id="btnMapaCotacao">Mapa Cotação</button>     ' +
        '</div>'
      )
    },
    {
      data: 'fornecedor',
      title: 'Fornecedor',
    },
    {
      data: 'nome',
      title: 'Nome',
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'codigoItemFornecedor',
      title: 'Código Fornecedor',
    },
    {
      data: 'descricaoItemFornecedor',
      title: 'Descrição Fornecedor',
    },
    {
      data: 'corItemFornecedor',
      title: 'Cor Fornecedor',
    },
    {
      data: 'fatorConversaoFornecedor',
      title: 'Fator Conversão Fornecedor',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'observacaoFornecedor',
      title: 'Obs. Fornecedor',
    },
    {
      data: 'dataEntregaFornecedor',
      title: 'Entrega Fornecedor',
      render: function (data) {
        return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
      }
    },
    {
      data: 'moeda',
      title: 'Moeda',
    },
    {
      data: 'substituicaoTributaria',
      title: 'Substituição Tributária',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'ipi',
      title: 'IPI',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'fabricante',
      title: 'Fabricante',
    },
    {
      data: 'modalidadeFrete',
      title: 'Modalidade Frete',
    },
    {
      data: 'condicao',
      title: 'Condição',
    },
    {
      data: 'desconto',
      title: 'Desconto',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'frete',
      title: 'Frete',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'icms',
      title: 'Icms',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'quantidadeSolicitacao',
      title: 'Quantidade Solicitação',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'precoSolicitacao',
      title: 'Preço Solicitação',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'dataEntregaSolicitacao',
      title: 'Entrega Solicitação',
      render: function (data) {
        return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
      }
    },
    {
      data: 'quantidadeCotada',
      title: 'Quantidade Cotada',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'validade',
      title: 'Validade',
      render: function (data) {
        return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
      }
    },
    {
      data: 'situacao',
      title: 'Situação',
    },
    {
      data: 'status',
      title: 'Status',
    },
    {
      data: 'especificacaoSolicitacao',
      title: 'Especificação Solicitação',
    },
    {
      data: 'observacaoSolicitacao',
      title: 'Obs. Solicitação',
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  $('#tabelaItens').DataTable({
    sort: false,
    paging: true,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    pageLength: 23,
    colReorder: true,
    serverSide: true,
    ajax: {
      url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/centralcompras/cotacao/v1/itensnegociados`,
      type: "POST",
      headers: {
        'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
      },
      data: function (data) {
        const { start, length, draw } = data;
        return JSON.stringify({
          filtros,
          paginacao: {
            quantidadeMaximaRegistros: length,
            quantidadeRegistrosPular: start,
            contadorRequisicoes: draw,
          },
          empresa: getCookie('empresa'),
        })
      },
      dataSrc: function (json) {
        if (!json || !json.data) {
          return []
        }
        ItensCotacaoNegociados.idSelecionado = json.data[0]?.id
        return json.data
      },
      cache: true,
      beforeSend: function () {
        $.LoadingOverlay('show')
      },
      complete: function () {
        $.LoadingOverlay('hide')
      },
    },
    autoWidth: true,
    columns,
    scrollX: true,
    scrollY: '737px',
  })
  UtilsCentralCompras.criarContainerBotoes({
    tabela: 'tabelaItens',
  })
  UtilsCentralCompras.habilitarEsconderColunas({
    tabela: 'tabelaItens',
    tela: 'ItensCotacaoNegociados',
  })
  UtilsCentralCompras.habilitarExportarCsv({
    tabela: 'tabelaItens',
    status: 'N',
    tipo: 'COT',
    retornarFiltros: ItensCotacaoNegociados.retornarFiltros,
  })
}

ItensCotacaoNegociados.retornarFiltros = async function () {
  const cotacao = await formataListas($('#txtCotacao').val().toString())
  const solicitacao = await formataListas($('#txtSolicitacao').val().toString())
  const fornecedor = await formataListas($('#txtFornecedor').val().toString())
  const codigo = await formataListas($('#txtCodigo').val().toString())
  const cor = await formataListas($('#txtCor').val().toString())
  const tamanho = await formataListas($('#txtTamanho').val().toString())
  const solicitante = await formataListas($('#txtSolicitante').val().toString())
  const centroCusto = await formataListas($('#txtCentroCusto').val().toString())
  const codigoFornecedor = $('#txtCodigoFornecedor').val()
  const corFornecedor = $('#txtCorFornecedor').val()
  const validadeDe = $('#txtValidadeDe').val() || '1200-01-01'
  const validadeAte = $('#txtValidadeAte').val() || '1200-01-01'
  const respostaDe = $('#txtRespostaDe').val() || '1200-01-01'
  const respostaAte = $('#txtRespostaAte').val() || '1200-01-01'
  const tipo = await formataListas($('#txtTipo').val().toString())

  return {
    cotacao,
    solicitacao,
    fornecedor,
    codigo,
    cor,
    tamanho,
    solicitante,
    centroCusto,
    codigoFornecedor,
    corFornecedor,
    validadeDe,
    validadeAte,
    respostaDe,
    respostaAte,
    tipo,
  }
}