window.GraficosCentralCompras = window.GraficosCentralCompras || {}

GraficosCentralCompras.criarGrafico = ({ container, data, categories }) => {
  const options = {
    plotOptions: {
      pie: {
        customScale: 1
      }
    },
    series: data,
    chart: {
      id: "chart",
      type: 'pie',
      height: 300,
      animations: {
        enabled: true,
        speed: 1500,
        animateGradually: {
          enabled: true,
          delay: 150
        },
        dynamicAnimation: {
          enabled: true,
          speed: 350
        }
      },
    },
    labels: categories,
    fill: {
      type: 'gradient',
      gradient: {
        shade: 'dark',
        type: "horizontal",
        shadeIntensity: 0.125,
        inverseColors: false,
        opacityFrom: 1,
        opacityTo: 1,
        stops: [0, 100, 100],
        colorStops: []
      }
    },
    colors: ['rgba(191, 191, 27, 0.75)', 'rgba(29, 138, 1, 0.75)', 'rgba(186, 103, 2, 0.75)', 'rgba(156, 5, 5, 0.75)', 'rgba(122, 121, 121, 0.75)',],
    stroke: {
      show: true,
      width: 2.5,
      colors: ['var(--borda-grafico)']
    },
    dataLabels: {
      enabled: true,
      style: {
        fontSize: '13px',
        fontWeight: 100,
        colors: ['#fff'],
      },
    },
    legend: {
      inverseOrder: true,
      position: 'bottom',
      labels: {
        colors: '#333',
        useSeriesColors: true
      }
    },
    tooltip: {
      style: {
        colors: ['#000'],
      },
      theme: 'dark',
      y: {
        formatter: (value) => `${value} itens`
      }
    }
  }

  $(container).removeClass('d-none')
  const grafico = new ApexCharts(document.querySelector(container), options)
  grafico.render().then(() => grafico.renderizado = true)
}

GraficosCentralCompras.criarGrafico2 = ({ container, data, categories }) => {
  const options = {
    chart: {
      type: 'bar'
    },
    plotOptions: {
      bar: {
        horizontal: true
      }
    },
    colors: ['rgba(191, 191, 27, 0.75)', 'rgba(29, 138, 1, 0.75)', 'rgba(186, 103, 2, 0.75)', 'rgba(156, 5, 5, 0.75)', 'rgba(122, 121, 121, 0.75)',],
    series: [{
      data,
    }]
  }

  $(container).removeClass('d-none')
  const grafico = new ApexCharts(document.querySelector(container), options)
  grafico.render().then(() => grafico.renderizado = true)
}