$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Filtro',
        description: 'Aqui podemos aplicar o filtro por tipo de turno.',
        position: 'bottom'
      }
    },
    {
      element: '#btnNovoTemplate',
      popover: {
        title: 'Inclusão',
        description: 'Neste botão, podemos incluir um novo registro de horários.',
        position: 'bottom'
      }
    },
    {
      element: '#tabelaTurno',
      popover: {
        title: 'Informações da Tabela',
        description: 'Aqui é apresentado os registro da tabela.',
        position: 'top'
      }
    },
    {
      element: '#tutorialTabela',
      popover: {
        title: 'Opções de Alterar e Excluir',
        description: 'Neste botão, podemos escolher entre alterar ou excluir o registro.',
        position: 'top'
      }
    },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#btn-ConsultaTurnos').pesquisa('#txtCadStatusConsulta', 'TURNO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TURNO", "camposSelect":[ "TURNO", "DESCRICAO" ], "where": null}', 'Pesquisar Turno', 'Turno');
  $('#txtCadStatusConsulta').autocompleta(1, `JSON={ "tabela":"TURNO", "camposSelect":["TURNO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btn-limpa-ConsultaTurnos, #btnLimparFiltros').on('click', function () {
    $('#txtCadStatusConsulta').val('');
  });
  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').on('click', async function consultaTabela() {

    let colunas = [];
    $.LoadingOverlay("show");

    try {
      if ($.fn.DataTable.isDataTable('#tabelaTurno')) {
        $("#tabelaTurno").DataTable().destroy();
        $("#tabelaTurno").empty();
      }

      let ajaxData = {};

      if ($("#txtCadStatusConsulta").val() == '') {
        camposSelect = `["TURNO_HORARIOS.TURNO", "TURNO.DESCRICAO", "TURNO_HORARIOS.DIA", "TURNO_HORARIOS.ENTRADA", "TURNO_HORARIOS.INTER_INI" , ` +
          `"TURNO_HORARIOS.INTER_FIM", "TURNO_HORARIOS.SAIDA", "TURNO_HORARIOS.TOTAL", "TURNO_HORARIOS.DSR", "TURNO_HORARIOS.PAUSAM_INI", ` +
          `"TURNO_HORARIOS.PAUSAM_FIM", "TURNO_HORARIOS.PAUSAT_INI", "TURNO_HORARIOS.PAUSAT_FIM", "TURNO_HORARIOS.ADDNOT_INI", "TURNO_HORARIOS.ADDNOT_FIM",` +
          `"TURNO_HORARIOS.TOLERANCIA", "TURNO_HORARIOS.TOLER_EXTRA", "TURNO_HORARIOS.TOLER_NOT", "TURNO_HORARIOS.DIA_INTERC", "TURNO_HORARIOS.DATA_INTERC", "TURNO_HORARIOS.PERC_EXTRA" ]`;
        colunas = ["TURNO", "DESC_TURNO", "DIA", "ENTRADA", "INTER_INI", "INTER_FIM", "SAIDA", "TOTAL", "DSR", "PAUSAM_INI", "PAUSAM_FIM", "PAUSAT_INI",
          "PAUSAT_FIM", "ADDNOT_INI", "ADDNOT_FIM", "TOLERANCIA", "TOLER_EXTRA", "TOLER_NOT", "DIA_INTERC", "DATA_INTERC", "PERC_EXTRA"];

        ajaxData = `{ "tabela":"TURNO_HORARIOS", "camposSelect":["TURNO_HORARIOS.TURNO", "TURNO.DESCRICAO", "TURNO_HORARIOS.DIA", "TURNO_HORARIOS.ENTRADA", "TURNO_HORARIOS.INTER_INI" ,` +
          `"TURNO_HORARIOS.INTER_FIM", "TURNO_HORARIOS.SAIDA", "TURNO_HORARIOS.TOTAL", "TURNO_HORARIOS.DSR", "TURNO_HORARIOS.PAUSAM_INI", ` +
          `"TURNO_HORARIOS.PAUSAM_FIM", "TURNO_HORARIOS.PAUSAT_INI", "TURNO_HORARIOS.PAUSAT_FIM", "TURNO_HORARIOS.ADDNOT_INI", "TURNO_HORARIOS.ADDNOT_FIM", ` +
          `"TURNO_HORARIOS.TOLERANCIA", "TURNO_HORARIOS.TOLER_EXTRA", "TURNO_HORARIOS.TOLER_NOT", "TURNO_HORARIOS.DIA_INTERC", "TURNO_HORARIOS.DATA_INTERC", "TURNO_HORARIOS.PERC_EXTRA"], ` +
          `"leftjoin": [{"tabela": "TURNO", "condicao": "TURNO.TURNO = TURNO_HORARIOS.TURNO"}],` +
          `"where": ["1=1"]}`;
      } else {
        camposSelect = `["TURNO_HORARIOS.TURNO", "TURNO.DESCRICAO", "TURNO_HORARIOS.DIA", "TURNO_HORARIOS.ENTRADA", "TURNO_HORARIOS.INTER_INI" ,` +
          `"TURNO_HORARIOS.INTER_FIM", "TURNO_HORARIOS.SAIDA", "TURNO_HORARIOS.TOTAL", "TURNO_HORARIOS.DSR", "TURNO_HORARIOS.PAUSAM_INI",` +
          `"TURNO_HORARIOS.PAUSAM_FIM", "TURNO_HORARIOS.PAUSAT_INI", "TURNO_HORARIOS.PAUSAT_FIM", "TURNO_HORARIOS.ADDNOT_INI", "TURNO_HORARIOS.ADDNOT_FIM",` +
          `"TURNO_HORARIOS.TOLERANCIA", "TURNO_HORARIOS.TOLER_EXTRA", "TURNO_HORARIOS.TOLER_NOT", "TURNO_HORARIOS.DIA_INTERC", "TURNO_HORARIOS.DATA_INTERC", "TURNO_HORARIOS.PERC_EXTRA" ]`;
        colunas = ["TURNO", "DESC_TURNO", "DIA", "ENTRADA", "INTER_INI", "INTER_FIM", "SAIDA", "TOTAL", "DSR", "PAUSAM_INI", "PAUSAM_FIM", "PAUSAT_INI",
          "PAUSAT_FIM", "ADDNOT_INI", "ADDNOT_FIM", "TOLERANCIA", "TOLER_EXTRA", "TOLER_NOT", "DIA_INTERC", "DATA_INTERC", "PERC_EXTRA"];

        ajaxData = `{ "tabela":"TURNO_HORARIOS", "camposSelect":["TURNO_HORARIOS.TURNO", "TURNO.DESCRICAO", "TURNO_HORARIOS.DIA", "TURNO_HORARIOS.ENTRADA", "TURNO_HORARIOS.INTER_INI" , ` +
          `"TURNO_HORARIOS.INTER_FIM", "TURNO_HORARIOS.SAIDA", "TURNO_HORARIOS.TOTAL", "TURNO_HORARIOS.DSR", "TURNO_HORARIOS.PAUSAM_INI", ` +
          `"TURNO_HORARIOS.PAUSAM_FIM", "TURNO_HORARIOS.PAUSAT_INI", "TURNO_HORARIOS.PAUSAT_FIM", "TURNO_HORARIOS.ADDNOT_INI", "TURNO_HORARIOS.ADDNOT_FIM",` +
          `"TURNO_HORARIOS.TOLERANCIA", "TURNO_HORARIOS.TOLER_EXTRA", "TURNO_HORARIOS.TOLER_NOT", "TURNO_HORARIOS.DIA_INTERC", "TURNO_HORARIOS.DATA_INTERC", "TURNO_HORARIOS.PERC_EXTRA"],` +
          `"leftjoin": [{"tabela": "TURNO", "condicao": "TURNO.TURNO = TURNO_HORARIOS.TURNO"}],` +
          `"where": ["1=1 AND TURNO_HORARIOS.TURNO='${pegaChave("#txtCadStatusConsulta")}'"]}`;
      };

      let response = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON=${ajaxData}`, null);
      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      const dataSetCols = [
        { data: "TURNO", title: "Turno" },
        { data: "DESCRICAO", title: "Desc. Turno" },
        { data: "DIA", title: "Dia" },
        { data: "ENTRADA", title: "Entrada" },
        { data: "INTER_INI", title: "Inter. Iní." },
        { data: "INTER_FIM", title: "Inter. Fim" },
        { data: "SAIDA", title: "Saída" },
        { data: "TOTAL", title: "Total" },
        { data: "DSR", title: "DSR" },
        { data: "PAUSAM_INI", title: "Pausa M. Iní." },
        { data: "PAUSAM_FIM", title: "Pausa M. Fim" },
        { data: "PAUSAT_INI", title: "Pausa T. Iní." },
        { data: "PAUSAT_FIM", title: "Pausa T. Fim" },
        { data: "ADDNOT_INI", title: "Add. Not. Iní." },
        { data: "ADDNOT_FIM", title: "Add. Not. Fim" },
        { data: "TOLERANCIA", title: "Tolerância" },
        { data: "TOLER_EXTRA", title: "Tolerância Extra" },
        { data: "TOLER_NOT", title: "Tolerância Not." },
        { data: "DIA_INTERC", title: "Dia Interc." },
        { data: "DATA_INTERC", title: "Data Interc." },
        { data: "PERC_EXTRA", title: "Perc. Extra" }
      ];

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      if (colunasInvisiveis == null || colunasInvisiveis.acessoCadHorarios == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadHorarios: ['EMPRESA'] }));
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      }

      if (jsonStr.RESULT[0].length > 0) {
        $('#tabelaTurno').DataTable({
          paging: true,
          searching: true,
          lengthChange: true,
          scrollX: true,
          scrollY: '350px',
          filter: true,
          info: true,
          order: true,
          autoWidth: true,
          destroy: true,
          data: jsonStr.RESULT[0],
          columns: dataSetCols,
          columnDefs: [
            {
              targets: [0], render: function (data, type, row) {
                return retornaBotaoOpcoes(data);
              }
            },
            {
              targets: [9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20], visible: false
            },
            {
              "targets": [3, 4, 5, 6, 7],
              'render': function (data, type, full, meta) {
                if (type === 'display') {
                  data = data.substring(11, 16);
                }

                return data;
              }
            }
          ]

        });

        $('#tabelaTurno_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaTurno_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const dados = $("#tabelaTurno").DataTable().data().toArray();
          await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Horários dos Turnos', '', '', 999, false, false, dados);
        });

        $('#tabelaTurno').DataTable().columns().every(function () {
          if ((colunasInvisiveis.acessoCadHorarios).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        });
      }

    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados dos itens.');
    } finally {
      $.LoadingOverlay("hide");
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaTurno').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.acessoCadHorarios ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["TURNO"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadHorarios: novasColunas }));

      $('#tabelaTurno').DataTable().columns().visible(true);

      $('#tabelaTurno').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" href="#txtTurno" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  $("#tabelaTurno").on("click", "#btn-editar", async function carregaDados() {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaTurno").DataTable().row($(this).parents("tr")).data();
      let registroLiberado = await verificarRegistro("CADTURNO", String(data.TURNO) + String(data.DIA));
      if (registroLiberado) {
        window.location.href = `cadhorarios/${(data.TURNO)}#${(data.DIA)}`;
      }
    }
    else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }

  });

  $('#btnConsultar').trigger('click');

  $('#tabelaTurno').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaTurno").DataTable().row($(this).parents("tr")).data();
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  const permissaoUsuarioLogado = await permissaoAcessos("CADHORARIOS");

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {

        let response = await requisicao('DELETE', '/sisplan/cadastros/V1/cadhorarios?', `DELETATURNO=${encodeURIComponent(data.TURNO)}&DELETADIA=${encodeURIComponent(data.DIA)}`, null);

        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/cadhorarios`;
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }

  };

  $('#tabelaTurno').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaTurno').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("CADHORARIOS", String(data.TURNO) + String(data.DIA));
      if (registroLiberado) {
        window.location.href = `cadhorarios/${(data.TURNO)}#${(data.DIA)}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });
});