function criaTabelaSubcaracteristicas(data) {
    function retornaBotaoOpcoes(data) {
        var retorno = '<div> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes subcaracteristicasDatatableButtonControl" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button type="button" class="dropdown-item subcaracteristicasDatatableButtonControl" title="Alterar" id="btnAlterar">Alterar</button>     ' +
            '    <button type="button" class="dropdown-item subcaracteristicasDatatableButtonControl" title="Excluir" id="btnExcluir">Excluir</button>     ' +
            '</div>';
        return retorno;
    }

    if ($.fn.DataTable.isDataTable('#tabelaSubcaracteristicas')) {
        $('#tabelaSubcaracteristicas').DataTable().destroy();
        $('#tabelaSubcaracteristicas').empty();
    }

    const columns = [
        {
            data: 'ORDEM',
            title: 'Ordem'
        },
        {
            data: 'COD_APL',
            title: 'Aplicação'
        },
        {
            data: 'DESC_APL',
            title: 'Desc. Aplicação'
        },
        {
            data: 'OPCIONAL',
            title: 'Código'
        },
        {
            data: 'DESC_OPCIONAL',
            title: 'Descrição'
        },
        {
            data: 'VALOR_VENDA',
            title: 'Valor Venda'
        },
        {
            data: 'ATIVO',
            title: 'Ativo'
        },
        {
            data: 'IMP_NFE',
            title: 'Imp. NFe'
        },
        {
            data: 'TEMPO_ADC_COST',
            title: 'Tempo'
        },
        {
            data: 'PADRAO',
            title: 'Padrão'
        },
        {
            data: 'ID',
            title: 'Id'
        },
    ];

    $("#tabelaSubcaracteristicas").DataTable({
        sort: false,
        paging: false,
        destroy: true,
        lengthChange: false,
        filter: false,
        info: false,
        columnDefs: [
            {
                targets: [0],
                render: function (data) {
                    return retornaBotaoOpcoes(data);
                }
            },
            {
                targets: [10],
                visible: false
            },
        ],
        autoWidth: true,
        data,
        columns
    }).draw(false);
}

function selectFirstRecordCaracteristicas() {
    setTimeout(() => {
        if ($('#tabelaSubcaracteristicas').DataTable().data().length > 0) {
            $($('#tabelaSubcaracteristicas tr')[1]).trigger('click');
        }
    }, 0)
}

function habilitaEdicaoSubcaracteristica() {
    const aplicacoesData = JSON.stringify($('#tabelaAplicacoesCaracteristicas').DataTable().data().toArray())
    const consumosData = JSON.stringify($('#tabelaConsumosCaracteristicas').DataTable().data().toArray())
    localStorage.setItem('aplicacoesSubcaracteristicas', aplicacoesData)
    localStorage.setItem('consumosSubcaracteristicas', consumosData)
    $('.caracteristicaControl').prop('disabled', false)
    $('#btnIncluirSubcaracteristica').addClass('d-none')
    $('#btnConfirmarSubcaracteristica').removeClass('d-none')
    $('#btnDesistirSubcaracteristica').removeClass('d-none')
    $('#divTabelaSubcaracteristicas').addClass('d-none')
    $('#divVincular').removeClass('d-none')
    $('.subcaracteristicasDatatableButtonControl').prop('disabled', true)
}

function desabilitaEdicaoSubcaracteristica() {
    localStorage.removeItem('aplicacoesSubcaracteristicas')
    localStorage.removeItem('consumosSubcaracteristicas')
    $('.caracteristicaControl').prop('disabled', true)
    $('#btnIncluirSubcaracteristica').removeClass('d-none')
    $('#btnConfirmarSubcaracteristica').addClass('d-none')
    $('#btnDesistirSubcaracteristica').addClass('d-none')
    $('#divTabelaSubcaracteristicas').removeClass('d-none')
    $('#divVincular').addClass('d-none')
    desabilitaEdicaoAplicacoesCaracteristica()
    desabilitaEdicaoConsumosCaracteristica()
    $('.subcaracteristicasDatatableButtonControl').prop('disabled', false)
    $("#tabelaSubcaracteristicas tr").removeClass("selected")
    $('#txtAplicacaoSubcaracteristica').val('')
    $('#txtCaracteristicaSubcaracteristica').val('')
    $('#txtValorVendaSubcaracteristica').val('')
    $('#txtTempoAdcCosturaSubcaracteristica').val('')
    $('#cbAtivoSubcaracteristica').prop('checked', true)
    $('#cbImprimeNFeSubcaracteristica').prop('checked', false)
    $('#cbPadraoSubcaracteristica').prop('checked', false)
    selectFirstRecordCaracteristicas()
}

function insereValoresEdicaoSubcaracteristica(data) {
    insereValor('#txtAplicacaoSubcaracteristica', data.COD_APL, data.DESC_APL)
    insereValor('#txtCaracteristicaSubcaracteristica', data.OPCIONAL, data.DESC_OPCIONAL)
    insereValor('#txtValorVendaSubcaracteristica', data.VALOR_VENDA)
    insereValor('#txtTempoAdcCosturaSubcaracteristica', data.TEMPO_ADC_COST)
    $('#cbAtivoSubcaracteristica').prop('checked', data.ATIVO === 'S')
    $('#cbPadraoSubcaracteristica').prop('checked', data.PADRAO === 'S')
    $('#cbImprimeNFeSubcaracteristica').prop('checked', data.IMP_NFE === 'S')
}

function adicionaRegistroSubcaracteristica(data) {
    try {
        const datatable = $("#tabelaSubcaracteristicas").DataTable()
        const selectedRow = datatable.rows(".selected")
        const datatableData = datatable.data().toArray()
        const editingRegister = selectedRow.data().toArray()

        if (!editingRegister || editingRegister.length === 0) {
            if (datatableData.find(e => e.COD_APL === data.COD_APL && e.OPCIONAL === data.OPCIONAL)) {
                msgErro('Esse registro já existe, impossível continuar.')
                return
            }

            const currentMaxOrdem = datatableData.reduce((max, obj) => {
                return obj.ORDEM > max ? obj.ORDEM : max
            }, 0)

            data.ORDEM = currentMaxOrdem + 1
            data.ID = 0

            datatable.row.add(data).draw(false)
        } else {
            const [index] = selectedRow.indexes().toArray()
            const existingRegisterCount = datatableData.filter((e, i) => e.COD_APL === data.COD_APL && e.OPCIONAL === data.OPCIONAL && index !== i)

            if (existingRegisterCount && existingRegisterCount.length > 0) {
                msgErro('Esse registro já existe, impossível continuar.')
                return
            }

            if (editingRegister.length > 1) {
                throw new Error()
            }

            const [dataSelected] = editingRegister
            data.ID = dataSelected.ID
            data.ORDEM = dataSelected.ORDEM

            datatable.row(index).data(data).draw(false)
        }

        atualizaValoresAplicacoesSubcaracteristicas({ ...data, DESCRICAO: data.DESC_APL, SUBCARACTERISTICA: data.OPCIONAL })
        filtraAplicacoesSubcaracteristicas(data)
        filtraConsumosSubcaracteristicas(data)
    } catch (e) {
        console.log(e)
        msgErro('Ocorreu um problema ao inserir/editar o registro, por favor tente novamente.')
    } finally {
        desabilitaEdicaoSubcaracteristica()
    }
}

function excluiSubcaracteristica(row) {
    const data = row.data()
    row.remove().draw(false)
    removeAplicacoesSubcaracteristicas(data)
    removeConsumosSubcaracteristicas(data)
}