$(document).ready(async function () {
  $('#btnIncluirObsSerasa').on('click', async function () {
    buscaDataAtual();
    $('#txtObsSerasa').val('');
    $('#btnIncluirObsSerasa').addClass('d-none');
    $('#btnGravarObsSerasa').removeClass('d-none');
    $('#btnCancelarObsSerasa').removeClass('d-none');
    $('#btnAlterarObsSerasa').addClass('d-none');
    $('#btnConsultaCertificadoObsSerasa').addClass('d-none');
    $('#btnFecharModalObsSerasa').addClass('d-none');
    $('#btnAbrirAnexosObsSerasa').addClass('d-none');
    $('#txtObsSerasa').attr('disabled', false);
    $('#txtObsSerasa').attr('readonly', false);
  });

  $('#btnCancelarObsSerasa').on('click', async function () {
    $('#btnIncluirObsSerasa').removeClass('d-none');
    $('#btnGravarObsSerasa').addClass('d-none');
    $('#btnCancelarObsSerasa').addClass('d-none');
    $('#btnAlterarObsSerasa').removeClass('d-none');
    $('#btnConsultaCertificadoObsSerasa').removeClass('d-none');
    $('#btnFecharModalObsSerasa').removeClass('d-none');
    $('#btnAbrirAnexosObsSerasa').removeClass('d-none');
    $('#txtObsSerasa').attr('disabled', true);
    $('#txtObsSerasa').attr('readonly', true);
  });

  $('#btnAlterarObsSerasa').on('click', function () {
    $('#btnIncluirObsSerasa').addClass('d-none');
    $('#btnGravarObsSerasa').removeClass('d-none');
    $('#btnCancelarObsSerasa').removeClass('d-none');
    $('#btnAlterarObsSerasa').addClass('d-none');
    $('#btnConsultaCertificadoObsSerasa').addClass('d-none');
    $('#btnFecharModalObsSerasa').addClass('d-none');
    $('#btnAbrirAnexosObsSerasa').addClass('d-none');
    $('#txtObsSerasa').attr('disabled', false);
    $('#txtObsSerasa').attr('readonly', false);
  });

  async function testeConexao() {
    try {
      $.LoadingOverlay('show');
      try {
        let porta;
        porta = getCookie('porta_api_local');

        if (porta == '') {
          return false;
        }

        const response = await requisicao_ecf('GET', '/conexao/conexao?', ``, 1000);

        if (!response) {
          return false;
        }
        if (response.status == 200) {
          return true;
        }
      } catch (error) {
        console.error(error);
        return false;
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function buscaDataAtual() {
    Date.prototype.toDateInputValue = (function () {
      var local = new Date(this);
      local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
      return local.toJSON().slice(0, 10);
    });

    $(document).ready(function () {
      $('#txtDataObsSerasa').val(new Date().toDateInputValue());
    });
  }

  $('input[name="checkCert"]').change(function () {
    if ($(this).is(':checked')) {
      $('input[name="checkCert"]').not(this).prop('checked', false);
    }
  });

  function validaTagPreenchida(json) {
    let naoPreenchido = [];

    for (var chave in json) {
      if (json.hasOwnProperty(chave)) {
        if (chave == 'bvcdlCodigoCdl' && !json[chave]) {
          naoPreenchido.push('CODIGOCDL')
        }
        if (chave == 'bvcdlCodigoAssociado' && !json[chave]) {
          naoPreenchido.push('CODIGOASSOCIADO')
        }
        if (chave == 'bvcdlCodigoFilial' && !json[chave]) {
          naoPreenchido.push('CODIGOFILIAL')
        }
        if (chave == 'bvcdlSenha' && !json[chave]) {
          naoPreenchido.push('SENHA')
        }
        if (chave == 'bvcdlUsuario' && !json[chave]) {
          naoPreenchido.push('USUARIO')
        }
        if (chave == 'bvcdlWsdl' && !json[chave]) {
          naoPreenchido.push('WSDL')
        }
        if (chave == 'bvcdlUrl' && !json[chave]) {
          naoPreenchido.push('URL')
        }
        if (chave == 'bvcdlWsdlConsulta' && !json[chave]) {
          naoPreenchido.push('WSDLCONSULTA')
        }
        if (chave == 'bvcdlUrlConsulta' && !json[chave]) {
          naoPreenchido.push('URLCONSULTA')
        }
      }
    }
    return naoPreenchido;
  }

  async function abreModalApiLocal(serasa, url) {
    try {
      $.LoadingOverlay("SHOW");
      requisicao_ecf("POST", url, '', JSON.stringify(serasa)).then((res) => {
        return res.status
      })
    } catch (err) {
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function preencheNovoSerasa(texto) {
    buscaDataAtual();
    $('#txtObsSerasa').val('');
    $('#btnIncluirObsSerasa').addClass('d-none');
    $('#btnGravarObsSerasa').removeClass('d-none');
    $('#btnCancelarObsSerasa').removeClass('d-none');
    $('#btnAlterarObsSerasa').addClass('d-none');
    $('#btnImprimirObsSerasa').addClass('d-none');
    $('#btnAnexarObsSerasa').addClass('d-none');
    $('#btnConsultaCertificadoObsSerasa').addClass('d-none');
    $('#btnFecharModalObsSerasa').addClass('d-none');
    $('#btnAbrirAnexosObsSerasa').addClass('d-none');
    $('#txtObsSerasa').attr('disabled', false);
    $('#txtObsSerasa').attr('readonly', false);
    $('#txtObsSerasa').val(texto);
  }

  $('#btnGravarObsSerasa').on('click', async function () {
    try {
      $.LoadingOverlay("show");

      let Serasa = {
        ID: $('#txtNumeroObsSerasa').val(),
        Obs: $('#txtObsSerasa').val(),
        Codcli: pegaChave('#txtClienteObsSerasa'),
        Data: $('#txtDataObsSerasa').val(),
        Usuario: getCookie('g_usuario_logado'),
        Ordem: $('#tabelaObsSerasa').DataTable().rows().count() + 1
      };

      let response = await requisicao('POST', '/Sisplan/Cadastros/v1/serasa?', `JSON=${encodeURIComponent(JSON.stringify(Serasa))}`, null);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      };

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay("hide");
      toastr.success(
        `Cadastro efetuado com sucesso!
          Serasa: ${Serasa.Numero}`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#modal_obs_serasa').modal('hide');
          $('#btnCancelarObsSerasa').trigger('click');
          $('#abaObsSerasa').trigger('click');
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function buscaIniApiLocal(serasa) {
    try {
      const response = await requisicao_ecf('GET', `/serasa/ini?`, `EMPRESADAO=${JSON.stringify(serasa)}`, '', 6000);

      const jsonIni = await response.json();
      if (!jsonIni) {
        return
      }
      if (response.status != 200) {
        console.error(jsonIni.RESULT[0][0].mensagem);
        return;
      }
      return jsonIni;
    } catch (err) {
    }
  }

  $('#btnConsultaCertificadoObsSerasa').on('click', async function () {
    $.LoadingOverlay("show");
    try {

      const checkMarcado = parseInt($('input[name="checkCert"]:checked').val()) || -1;

      if (checkMarcado != 8 && !await testeConexao()) {
        throw msgAlerta('Não está conectado a Api Local!');
      }

      switch (checkMarcado) {
        case 0: await consultaBoaVista(); break;
        case 1: await consultaSerasa(); break;
        case 2: await consultaDossieTotal(); break;
        case 3: await consultaConnect(); break;
        case 4: await consultaSerasaSitnet(); break;
        case 5: await consultaSerasaSCC(); break;
        case 6: await consultaBoaVistaACP(); break;
        case 7: await consultaBoaVistaSCPC(); break;
        case 8: await consultaDepsMix(); break;
        default: break;
      }

    } finally {
      $.LoadingOverlay("hide");
    }
    
  });

  async function consultaBoaVista() {
    const usuarioPermitido = getCookie('cod_usuario') == '0000' ? 'S' : await buscaValor('ACESSO_USUARIOS', 'USA_SERASA', 'NOME', getCookie('g_usuario_logado'));
    if (usuarioPermitido == 'N') {
      throw msgAlerta('Usuário não tem permissão para acessar consulta ao serasa, verifique com o administrador do sistema. (Checar Cadastro de usuario - Utilizar consulta SERASA)');
    }

    const Serasa = {
      Cnpj: $('#txtCNPJ').val(),
      Numero: $('#txtNumeroObsSerasa').val(),
      Parametro: 'N',
      UF: 'SC',
      empresadao: await retornaInformacaoEmpresa()
    };

    const jsonIni = await buscaIniApiLocal(Serasa)
    if (!jsonIni) {
      throw msgAlerta('Não conseguiu buscar os dados do Ini.')
    }
    if (!jsonIni.bvaUsuario && !jsonIni.bvaSenha) {
      throw msgAlerta('Para que seja possível conectar-se ao servidor Boa Vista é necessário um login e uma senha, verifique com a sisplan como adquirir esta credencial e também como configurar o sistema para ativar esta integração');
    }
    await abreModalApiLocal(Serasa, `/serasa/consultaboavista?`);
  }

  async function consultaSerasa() {
    const usuarioPermitido = getCookie('cod_usuario') == '0000' ? 'S' : await buscaValor('ACESSO_USUARIOS', 'USA_SERASA', 'NOME', getCookie('g_usuario_logado'));
    if (usuarioPermitido == 'N') {
      throw msgAlerta('Usuário não tem permissão para acessar consulta ao serasa, verifique com o administrador do sistema. (Checar Cadastro de usuario - Utilizar consulta SERASA)');
    }

    const Serasa = {
      Cnpj: $('#txtCNPJ').val(),
      Numero: $('#txtNumeroObsSerasa').val(),
      usuarioPermitido,
      Parametro: 'N',
      UF: 'SC',
      empresadao: await retornaInformacaoEmpresa()
    };

    const jsonIni = await buscaIniApiLocal(Serasa);

    if (!jsonIni.serasaEmail && !jsonIni.serasaSenha) {
      throw msgAlerta('Para que seja possível conectar-se ao servidor SERASA é necessário um login e uma senha, verifique com a sisplan como adquirir esta credencial e também como configurar o sistema para ativar esta integração');
    }
    await abreModalApiLocal(Serasa, `/serasa/consultaserasa?`);
  }

  async function consultaDossieTotal() {
    try {
      let jsonStr = '';
      const Serasa = {
        Cnpj: $('#txtCNPJ').val(),
        Numero: $('#txtNumeroObsSerasa').val(),
        UsuarioPermitido: 'S',
        Parametro: 'S',
        UF: 'SC',
        empresadao: await retornaInformacaoEmpresa()
      };
      const jsonIni = await buscaIniApiLocal(Serasa);

      if (!jsonIni.dossieCredencial) {
        msgAlerta('Tag CREDENCIAL no Ini não está configurada, deseja continuar?', async () =>
          jsonStr = await abreModalApiLocal(Serasa, `/serasa/consultadossietotal?`)
        )
      } else {
        jsonStr = await abreModalApiLocal(Serasa, `/serasa/consultadossietotal?`);
      }

      if (jsonStr.mensagem != "") {
        // $('#txtNumeroObsSerasa').val(await RetornaProximo('NUMERO', 'ENTID_OBS', 'NUMERO', 2));
        buscaDataAtual();
        $('#txtObsSerasa').val('');
        $('#btnIncluirObsSerasa').addClass('d-none');
        $('#btnGravarObsSerasa').removeClass('d-none');
        $('#btnCancelarObsSerasa').removeClass('d-none');
        $('#btnAlterarObsSerasa').addClass('d-none');
        $('#btnImprimirObsSerasa').addClass('d-none');
        $('#btnAnexarObsSerasa').addClass('d-none');
        $('#btnConsultaCertificadoObsSerasa').addClass('d-none');
        $('#btnFecharModalObsSerasa').addClass('d-none');
        $('#btnAbrirAnexosObsSerasa').addClass('d-none');
        $('#txtObsSerasa').attr('disabled', false);
        $('#txtObsSerasa').attr('readonly', false);
        $('#txtObsSerasa').val(jsonStr.mensagem);
      }
    } catch (err) {

    }
  }

  async function consultaConnect() {
    const Serasa = {
      Cnpj: $('#txtCNPJ').val(),
      Numero: $('#txtNumeroObsSerasa').val(),
      UsuarioPermitido: 'S',
      Parametro: 'S',
      UF: 'SC',
      empresadao: await retornaInformacaoEmpresa()
    };

    const jsonIni = await buscaIniApiLocal(Serasa);
    if (!jsonIni.connectPassword && !jsonIni.connetLogin && !jsonIni.connectIdClient && !jsonIni.connectUrl) {
      throw msgAlerta('LOGIN, PASSWORD, IDCLIENT e/ou URL na Tag CONSULTACONNECT, verifique');
    }
    await abreModalApiLocal(Serasa, `/serasa/consultaconnect?`);
  }

  async function consultaSerasaSitnet() {
    const Serasa = {
      Cnpj: $('#txtCNPJ').val(),
      Numero: $('#txtNumeroObsSerasa').val(),
      Emp_pat: getCookie('empresa'),
      empresadao: await retornaInformacaoEmpresa()
    };

    const jsonIni = await buscaIniApiLocal(Serasa);
    if (!jsonIni.snetUsuario && !jsonIni.snetSenha) {
      throw msgAlerta('USUARIO e SENHA não informadas no ini na Tag "INTEGRACAOSITENET" ou "INTEGRACAOSITENET_+(EMPRESA_LOGADA)". Verifique.');
    }

    requisicao_ecf("POST", `/serasa/consultasitenet?`, '', JSON.stringify(Serasa)).then((res) => {
      if (res.status == 200) {
        preencheNovoSerasa('Arquivo em anexo')
      } else {
        throw msgAlerta('Consulta não pode ser salva, verifique!')
      }
    })
  }

  async function consultaSerasaSCC() {
    const Serasa = {
      Cnpj: $('#txtCNPJ').val(),
      Numero: $('#txtNumeroObsSerasa').val(),
      Emp_pat: getCookie('empresa'),
      empresadao: await retornaInformacaoEmpresa()
    };
    const jsonIni = await buscaIniApiLocal(Serasa);
    if (!jsonIni.sccUrl && !jsonIni.sccUsuario && !jsonIni.sccSenha) {
      throw msgAlerta('URL, USUARIO e/ou SENHA não foram informados na Tag SERASA_SCC, verifique');
    }

    msgAlerta(`Deseja prosseguir com a consulta no serasa para o cliente ${pegaDescricao('#txtClienteObsSerasa')}?`, async () =>
      await abreModalApiLocal(Serasa, `/serasa/consultascc?`)
    );
  }

  async function consultaBoaVistaACP() {
    const Serasa = {
      Cnpj: $('#txtCNPJ').val(),
      Numero: $('#txtNumeroObsSerasa').val(),
      Emp_pat: getCookie('empresa'),
      empresadao: await retornaInformacaoEmpresa()
    };

    const jsonIni = await buscaIniApiLocal(Serasa);

    if (!jsonIni.bvacpUsuario && !jsonIni.bvacpSenha) {
      throw msgAlerta('USUARIO e/ou SENHA não informados na Tag BOAVISTA_ACP, deseja continuar mesmo assim?', async () =>
        await abreModalApiLocal(Serasa, `/serasa/consultaboavistaacp?`)
      );
    } else {
      await abreModalApiLocal(Serasa, `/serasa/consultaboavistaacp?`)
    }
  }

  async function consultaBoaVistaSCPC() {
    if (!$('#btnIncluirObsSerasa').hasClass('d-none')) {
      $('#btnIncluirObsSerasa').trigger('click')
    }
    const responseIni = await requisicao_ecf('GET', `/boavista/ini?`, ``, '', 6000)
    if (!responseIni) {
      return
    }

    const jsonIni = await responseIni.json()
    const tags = validaTagPreenchida(jsonIni)

    if (tags > 0) {
      throw new Error(tags + ' não informados na Tag BOAVISTA_CDL, favor verificar.')
    }

    requisicao_ecf("GET", `/boavista/consultaboavistascpc?CNPJ=${$('#txtCNPJ').val()}&`).then(async (response) => {
      const jsonStr = await response.json()

      $('#txtObsSerasa').val(jsonStr.mensagem)
    }).catch((err) => console.error(err))
  }

  $("#btnConfirmarDeps").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      const cnpj = $("#txtCNPJ").val();
      const auth = $("#txtAccessTokenDeps").val();
      const produtoDeps = $("#selectProdutosDeps").val();
      const reutilizarDados = $("#checkReutilizarDadosDeps").prop("checked");
      await requisicaoDepsMix(auth, cnpj, produtoDeps, reutilizarDados);    
      $("#modalProdutosDeps").modal("hide");    
    } catch (error)  {
      msgAlerta(error.message);
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  })
 
  $("#modalProdutosDeps").on("hidden.bs.modal", function () {
    removeProdutosDeps();
    $("#txtAccessTokenDeps").val("");
  })

  async function consultaDepsMix() {
    try {
      const login = await loginDeps();
      
      $("#txtAccessTokenDeps").val(login.access_token);
      preencheProdutosDeps(login.produtos);
      $("#modalProdutosDeps").modal("show");

    } catch (error) {
      msgAlerta(error.message);
      console.error(error);
    }
  }

  async function loginDeps() {
    const url = "/sisplan/deps/v1/entrar?";

    const response = await requisicao("POST", url, "", "", 60000);

    if (!response) {
      throw new Error("Não foi possível realizar o login na plataforma de Deps.");
    }
    
    const json = await response.json();
    if (response.status != 200) {
      throw new Error(json.mensagem);
    }

    return json;

  }

  function preencheProdutosDeps(produtosDeps) {
    produtosDeps.forEach(option => {
      $("#selectProdutosDeps").append(`<option value=${option.identificador}>${option.nome}</option>`);
    })
  }

  function removeProdutosDeps() {
    $("#selectProdutosDeps").empty();
    $("#selectProdutosDeps").append("<option value='' selected>Selecione uma opção</option>");
  }

  async function requisicaoDepsMix(auth, cnpj, produtoDeps, reutilizarDados = true) {
    const url = "/sisplan/deps/v1/depsmix?";
    const params = `AUTH=${auth}`+
                   `&CNPJ=${cnpj}`+
                   `&PRODUTO_DEPS=${produtoDeps}`+
                   `&REUTILIZAR_DADOS=${reutilizarDados}`;
    
    const response = await requisicao("GET", url, params, "", 120000);

    if (!response) {
      throw new Error("Não foi possível realizar a consulta Deps Mix.");
    }

    const json = await response.json();
    if (response.status != 200) {
      throw new Error(json.mensagem);
    }

    $("#iframeDepsMix").attr("src", json.mix.linkCompartilhamento);
    $("#modalDepsMix").modal("show");

  }

});
